<?php
// File: /public/deposit.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireLogin();
$user = getCurrentUser($pdo);

// Fetch Active Wallets
$stmt = $pdo->query("SELECT * FROM payment_wallets WHERE status = 'active'");
$wallets = $stmt->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = $_POST['amount'];
    $method = clean($_POST['method']);
    $tx_id = clean($_POST['transaction_id']);

    if ($amount <= 0) {
        setFlash('danger', 'Invalid amount.');
    } elseif (empty($tx_id)) {
        setFlash('danger', 'Transaction ID is required.');
    } else {
        try {
            // Create deposit request
            $stmt = $pdo->prepare("INSERT INTO deposits (user_id, amount, method, transaction_id, status) VALUES (?, ?, ?, ?, 'pending')");
            $stmt->execute([$user['id'], $amount, $method, $tx_id]);

            // Log transaction (status pending)
            logTransaction($pdo, $user['id'], 'deposit', $amount, "Deposit Request ($method) - Pending");

            setFlash('success', 'Deposit request submitted. Waiting for approval.');
            redirect('transactions.php');

        } catch (Exception $e) {
            setFlash('danger', 'Error: ' . $e->getMessage());
        }
    }
}

$page_title = "Deposit Funds";
include '../includes/header.php';
?>

<div class="card" style="max-width: 800px; margin: 0 auto;">
    <h3 class="mb-4">Add Funds</h3>
    <p class="text-muted mb-4">Choose a wallet, send payment, and submit the transaction ID.</p>
    
    <div class="stats-grid" style="margin-bottom: 30px; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));">
        <?php if (count($wallets) > 0): ?>
            <?php foreach ($wallets as $w): ?>
            <div class="stat-card" style="border: 1px solid var(--border-color); padding: 15px;">
                <h4 class="text-primary mb-2"><?php echo htmlspecialchars($w['name']); ?></h4>
                <div class="badge badge-primary mb-2"><?php echo htmlspecialchars($w['network']); ?></div>
                <div style="background: rgba(0,0,0,0.2); padding: 10px; border-radius: 5px; word-break: break-all; font-family: monospace; font-size: 0.9rem;">
                    <?php echo htmlspecialchars($w['address']); ?>
                </div>
            </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="alert alert-warning">No active payment wallets available. Please contact support.</div>
        <?php endif; ?>
    </div>

    <form method="POST" action="">
        <div class="form-group">
            <label>Amount (USD)</label>
            <input type="number" name="amount" class="form-control" step="0.01" required>
        </div>
        <div class="form-group">
            <label>Payment Method (Network)</label>
            <select name="method" class="form-control" required>
                <?php foreach ($wallets as $w): ?>
                    <option value="<?php echo htmlspecialchars($w['name'] . ' - ' . $w['network']); ?>">
                        <?php echo htmlspecialchars($w['name']); ?> (<?php echo htmlspecialchars($w['network']); ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Transaction Hash / ID</label>
            <input type="text" name="transaction_id" class="form-control" placeholder="Paste transaction ID here" required>
        </div>
        <button type="submit" class="btn btn-success btn-block">Submit Payment</button>
    </form>
</div>

<?php include '../includes/footer.php'; ?>
