<?php
// File: /public/withdraw.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireLogin();
$user = getCurrentUser($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = $_POST['amount'];
    $wallet = clean($_POST['wallet_address']);

    if ($amount <= 0) {
        setFlash('danger', 'Invalid amount.');
    } elseif ($amount > $user['balance']) {
        setFlash('danger', 'Insufficient balance.');
    } elseif (empty($wallet)) {
        setFlash('danger', 'Please provide a wallet address.');
    } else {
        try {
            $pdo->beginTransaction();

            // Deduct balance immediately
            $new_balance = $user['balance'] - $amount;
            $stmt = $pdo->prepare("UPDATE users SET balance = ? WHERE id = ?");
            $stmt->execute([$new_balance, $user['id']]);

            // Create withdrawal request
            $stmt = $pdo->prepare("INSERT INTO withdrawals (user_id, amount, wallet_address, status) VALUES (?, ?, ?, 'pending')");
            $stmt->execute([$user['id'], $amount, $wallet]);

            // Log transaction
            logTransaction($pdo, $user['id'], 'withdrawal', $amount, "Withdrawal request to $wallet");

            $pdo->commit();
            setFlash('success', 'Withdrawal request submitted successfully.');
            redirect('transactions.php');

        } catch (Exception $e) {
            $pdo->rollBack();
            setFlash('danger', 'Error: ' . $e->getMessage());
        }
    }
}

$page_title = "Withdraw Funds";
include '../includes/header.php';
?>

<div class="card" style="max-width: 600px; margin: 0 auto;">
    <h3 class="mb-4">Request Withdrawal</h3>
    <div class="alert alert-info mb-4">
        Available Balance: <strong><?php echo formatMoney($user['balance']); ?></strong>
    </div>

    <form method="POST" action="">
        <div class="form-group">
            <label>Amount (USD)</label>
            <input type="number" name="amount" class="form-control" step="0.01" max="<?php echo $user['balance']; ?>" required>
        </div>
        <div class="form-group">
            <label>Wallet Address (BTC/ETH/USDT)</label>
            <input type="text" name="wallet_address" class="form-control" placeholder="0x..." required>
        </div>
        <button type="submit" class="btn btn-danger btn-block">Submit Request</button>
    </form>
</div>

<?php include '../includes/footer.php'; ?>
